/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


/*

*/

var STBLayoutScroller				= Object.create(STBModule.prototype);
	STBLayoutScroller.name			= "LayoutScroller";
	STBLayoutScroller.script			= site.assets + "plugins/fullpage.js/plugin.js";


STBLayoutScroller.isActive = function() {

	if ($("body").attr("data-scroll-page") != "true") {
		return false;
	}

	return true;
}


STBLayoutScroller.startScript = function() {
	if (STBLayoutScroller.isActive()) {
		STBUtils.loadScriptCallback(
			STBLayoutScroller.script,
			STBLayoutScroller.initPlugin,
			true
		);
	}
}


STBLayoutScroller.initialize = function() {
	if (!STBLayoutScroller.isActive()) {
		return false;
	}

	//no diagonal edges for blocks
	STBBackgrounds.angleDisable();
	//menu is sticky all the time
	STBHeader.toggleSticky(true);

	//remove all ctas outside the <main> tag

	//footer its not collapsable
	STBFooter.collapseFooter(false);
	//remove topintro if exists
	STBModuleTopintro.disable();

	$(".page-header").remove();
	$(".page-header").addClass("fp-auto-height");

}

STBLayoutScroller.initPlugin = function() {

	if (!STBLayoutScroller.isActive()) {
		return false;
	}


	if ($("body > footer").length){

		$("body > main").append($("body > footer"));
		$("footer").addClass("fp-auto-height");
	}

	$("main > section").each(function() {

		$(this).addClass("full-page vertical-align-center").removeClass("half-page");

		if ($(this).hasClass("full-page")) {
		} else {
			$(this).addClass("fp-auto-height");
		}
	});


//	$(".page-header").remove();

	$("main").fullpage({
		sectionSelector: ' > *',
		verticalCentered: false,
		autoScrolling: true,
		_fixedElements: ".wrapper",
		normalScrollElements: ".wrapper",
		scrollOverflow: true,
	});


	//$("main").css 

}

STBLayoutScroller.configureSite = function() {	

}


STBLayoutScroller.runOnReady = function() {
	STBLayoutScroller.startScript();
}

STBLayoutScroller.runOnLoad = function() {
	if (!site.onepage) {
		//STBLayoutScroller.initPlugin();
	}
}

STBLayoutScroller.runOnContentUpdate = function() {
	if (site.onepage) {
		//STBLayoutScroller.initPlugin();
	}	
}

STBLayoutScroller.runOnResize = function() {

}

site.registerModule(STBLayoutScroller);